using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
namespace Application_Monitor
{
    /// <summary>
    /// This form acts as a start up form for the application. 
    /// Device and mode of communication can be slected using this form.
    /// </summary>
    public partial class frmMain : Form
    {
        #region Member Variable(s) Declaration
        
        
        internal static int intCommuincation = 0;
        #endregion

        public frmMain()
        {
            InitializeComponent();
          
        }       

        #region Private Event(s) Declaration
        private void btnOK_Click(object sender, EventArgs e)
        {

            this.Hide();
            //Open the ComPortSettings form, if RS 232 communication is selected
            if (rdRS232.Checked)
            {
                intCommuincation = (int)Constants.Communication_Type.RS_232;
                frmComPortSettings objComPort = new frmComPortSettings();
                objComPort.ShowDialog();
            }
            //Open the offline form, if offline mode is selected
            else if (rdOffline.Checked)
            {
                frmOffline objfrmOffline = new frmOffline();
                objfrmOffline.ShowDialog();
            }
            this.Show();
           
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            //Close the form
            this.Close();
        }

        private void frmMain_KeyDown(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
               
                case Keys.O:
                    {
                        rdRS232.Checked = true;
                        break;
                    }
                case Keys.F:
                    {
                        rdOffline.Checked = true;
                        break;
                    }

                default:
                    break;
            }

        }

        private void lnkAbout_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            frmAbout objAbout = new frmAbout();
            objAbout.ShowDialog();
        }

        private void frmMain_Load(object sender, EventArgs e)
        {
            this.AcceptButton = btnOK;
            this.CancelButton = btnCancel;
            btnOK.TabIndex = 0;
        }
        #endregion

       

       

       

    }
}